/**
 * @license
 * Copyright 2017 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
export var Rank;
(function (Rank) {
    Rank["R0"] = "R0";
    Rank["R1"] = "R1";
    Rank["R2"] = "R2";
    Rank["R3"] = "R3";
    Rank["R4"] = "R4";
    Rank["R5"] = "R5";
    Rank["R6"] = "R6";
})(Rank || (Rank = {}));
// Looks for upcasting types. Used, for example, in operations with mixed dtype
// inputs.
var UpcastInt32AndMap;
(function (UpcastInt32AndMap) {
    UpcastInt32AndMap["float32"] = "float32";
    UpcastInt32AndMap["int32"] = "int32";
    UpcastInt32AndMap["bool"] = "int32";
    UpcastInt32AndMap["complex64"] = "complex64";
})(UpcastInt32AndMap || (UpcastInt32AndMap = {}));
var UpcastBoolAndMap;
(function (UpcastBoolAndMap) {
    UpcastBoolAndMap["float32"] = "float32";
    UpcastBoolAndMap["int32"] = "int32";
    UpcastBoolAndMap["bool"] = "bool";
    UpcastBoolAndMap["complex64"] = "complex64";
})(UpcastBoolAndMap || (UpcastBoolAndMap = {}));
var UpcastFloat32AndMap;
(function (UpcastFloat32AndMap) {
    UpcastFloat32AndMap["float32"] = "float32";
    UpcastFloat32AndMap["int32"] = "float32";
    UpcastFloat32AndMap["bool"] = "float32";
    UpcastFloat32AndMap["complex64"] = "complex64";
})(UpcastFloat32AndMap || (UpcastFloat32AndMap = {}));
var UpcastComplex64AndMap;
(function (UpcastComplex64AndMap) {
    UpcastComplex64AndMap["float32"] = "complex64";
    UpcastComplex64AndMap["int32"] = "complex64";
    UpcastComplex64AndMap["bool"] = "complex64";
    UpcastComplex64AndMap["complex64"] = "complex64";
})(UpcastComplex64AndMap || (UpcastComplex64AndMap = {}));
const upcastTypeMap = {
    'float32': UpcastFloat32AndMap,
    'int32': UpcastInt32AndMap,
    'bool': UpcastBoolAndMap,
    'complex64': UpcastComplex64AndMap
};
export function upcastType(typeA, typeB) {
    if (typeA === 'string' || typeB === 'string') {
        if (typeA === 'string' && typeB === 'string') {
            return 'string';
        }
        throw new Error(`Can not upcast ${typeA} with ${typeB}`);
    }
    return upcastTypeMap[typeA][typeB];
}
/** Returns the output type after summation. */
export function sumOutType(type) {
    return upcastType(type, 'int32');
}
export function isWebGLData(values) {
    return values != null && typeof values === 'object' && 'texture' in values &&
        values.texture instanceof WebGLTexture;
}
export function isWebGPUData(values) {
    return typeof GPUBuffer !== 'undefined' && values != null &&
        typeof values === 'object' && 'buffer' in values &&
        values.buffer instanceof GPUBuffer;
}
//# sourceMappingURL=data:application/json;base64,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